﻿using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a tormented minotaur corpse" )]	
	public class TormentedMinotaur : Minotaur
	{
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.CrushingBlow;
		}
		
		private bool IsMLBoss;
		
      [Constructable]
		public TormentedMinotaur() : this ( true )
		{
		}
		
      [Constructable]
		public TormentedMinotaur( bool ismlboss ) : base()
		{
			IsMLBoss = ismlboss;
         Name = "Meraktus";
         Title = "the tormented minotaur";
			Body = 262;			

			SetStr( 703, 921 );
			SetDex( 92, 109 );
			SetInt( 33, 50 );

			SetHits( 6426 );

			SetDamage( 19, 39 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 66, 75 );
			SetResistance( ResistanceType.Fire, 35, 50 );
			SetResistance( ResistanceType.Cold, 40, 60 );
			SetResistance( ResistanceType.Poison, 41, 60 );
			SetResistance( ResistanceType.Energy, 41, 60 );

			SetSkill( SkillName.Wrestling, 100.5, 150.2 );
			SetSkill( SkillName.Tactics, 100.0, 120.1 );
			SetSkill( SkillName.MagicResist, 100.5, 120.9 );
			
			Fame = 24000;
			Karma = -9000;

			VirtualArmor = 50;
			PackItem( new RandomTalisman() );
			PackItem( new Tokens( Utility.RandomMinMax( 10, 20 ) ) );
			
			if ( IsMLBoss )
			{
			   PackItem( new Corruption() );
			   PackItem( Loot.RandomArcanistScroll() );
         }
		}
				
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosSuperBoss );
		}
		
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }

		public override void OnKilledBy( Mobile mob )
		{
			base.OnKilledBy( mob );

			if ( IsMLBoss && Paragon.CheckArtifactChance( mob, this ) )
			{
				Paragon.GiveMLArtifactTo( mob );
			}
		}

		public TormentedMinotaur( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}